var onQuotes = function (quote) {
    $('#currency_informer tr').removeClass('animTD_up_dark animTD_up_light animTD_down_dark animTD_down_light');

    animate = 'animTD_';
    animate += getClassDirection(quote.change) + '_';
    animate += $("#symbol_" + quote.symbol).hasClass('dark') ? 'dark' : 'light';

    var bid = getPrice(quote.bid, quote.digits);
    var ask = getPrice(quote.ask, quote.digits);

    if ($("#currency_informer").length > 0) {
        var symbol = "#symbol_" + quote.symbol;

        $(symbol + " td.direction div").removeClass('up down').addClass(getClassDirection(quote.change));
        $(symbol + " td.symbol").html(quote.symbol);
        $(symbol + " td.bid").html(bid)
            .css('color', getClassDirection(quote.change) == 'down' ? '#ee000e' : '#00961f');
        $(symbol + " td.ask").html(ask)
            .css('color', getClassDirection(quote.change) == 'down' ? '#ee000e' : '#00961f');

        $(symbol).addClass(animate);
    }
};

function getQuotes() {
    chrome.runtime.sendMessage({id: 'QUOTES_TABLE_NEEDS_QUOTES'});
}
getQuotes(); // Первый запрос когда таблица только вот выведена при наведении курсора.
window.setInterval(function() {
    getQuotes();
}, 3000);

chrome.extension.onMessage.addListener(function (request, sender, sendResponse) {
    switch (request.id) {
        case 'ON_QUOTES_RECEIVED':
            JSON.stringify(request);
            for (var i in request.quotes) {
                var quote = request.quotes[i];
                onQuotes(quote);
            }
            break;
        default:
            break;
    }
});

function getClassDirection(val) {
    return (val < 0 ? 'down' : 'up');
}

function getPrice(val, digits) {
    return retVal = (Number(val).toFixed(digits)).toString();
}