var RSSReader = function () {
    this.rssFeedUrl = 'https://news.instaforex.com/news';
    this.rss = [];
};
RSSReader.prototype = {

    save: function () {
        function compare(a, b) {
            if (a.timestamp < b.timestamp)
                return 1;
            if (a.timestamp > b.timestamp)
                return -1;
            return 0;
        }

        this.rss = this.rss.sort(compare);
        localStorage.rss = JSON.stringify(this.rss.slice(0, 7));
    },
    resetPulledRss: function () {
        this.rss = [];
    },

    getNews: function () {
        var xhr = new XMLHttpRequest();
        var self = this;
        xhr.open('GET', this.rssFeedUrl, true);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) {
                var resp_xml = xhr.responseXML;
                var div = document.createElement('div'); // Hacky technical element for cleaning text from &amp, &lt else
                if (resp_xml) {
                    self.resetPulledRss.call(self);
                    var items = resp_xml.getElementsByTagName('item');
                    for (var i = 0; i < items.length; i++) {
                        div.innerHTML = items[i].childNodes[0].textContent;
                        var title = div.firstChild.nodeValue;
                        var link = items[i].childNodes[1].textContent;
                        var pubDate = items[i].childNodes[3].textContent;

                        var timestamp = moment.utc(pubDate, "ddd, DD MMM YYYY HH:mm:ss").unix();
                        self.rss.push({title: title, timestamp: timestamp, link: link});
                    }
                    self.save.call(self);
                }
            }
        };
        xhr.send();
    }
};