var GmailChecker = function () {
    this.requestTimeout = 3000 * 2;  // 2 seconds
    this.gmailFeedUrl = "https://mail.google.com/mail/feed/atom?zx=" +
        encodeURIComponent('gmc' + parseInt(Date.now() * Math.random(), 10));
};

GmailChecker.prototype = {
    getInboxCount: function (onSuccess, onError) {

        var xhr = new XMLHttpRequest();
        var abortTimerId = window.setTimeout(function () {
            xhr.abort();  // synchronously calls onreadystatechange
        }, this.requestTimeout);

        function handleSuccess(count) {
            localStorage.requestFailureCount = 0;
            window.clearTimeout(abortTimerId);
            if (onSuccess)
                onSuccess(count);
        }

        var invokedErrorCallback = false;

        function handleError() {
            ++localStorage.requestFailureCount;
            window.clearTimeout(abortTimerId);
            if (onError && !invokedErrorCallback)
                onError();
            invokedErrorCallback = true;
        }

        function gmailNSResolver(prefix) {
            if (prefix == 'gmail') {
                return 'http://purl.org/atom/ns#';
            }
        }

        try {
            xhr.onreadystatechange = function () {
                if (xhr.readyState != 4)
                    return;

                if (xhr.responseXML) {
                    var xmlDoc = xhr.responseXML;
                    var fullCountSet = xmlDoc.evaluate("/gmail:feed/gmail:fullcount",
                        xmlDoc, gmailNSResolver, XPathResult.ANY_TYPE, null);
                    var fullCountNode = fullCountSet.iterateNext();
                    if (fullCountNode) {
                        handleSuccess(fullCountNode.textContent);
                        return;
                    } else {
                        console.error("Error: Feed retrieved, but no &lt;fullcount&gt; node found");
                    }
                }

                handleError();
            };

            xhr.onerror = function (error) {
                handleError();
            };

            xhr.open("GET", this.gmailFeedUrl, true);
            xhr.send(null);
        } catch (e) {
            console.error(e);
            handleError();
        }
    },
    startRequest: function () {
        this.getInboxCount(
            function (count) {
                localStorage.gmailUnreadCount = count;
            },
            function () {
                delete localStorage.gmailUnreadCount;
            }
        );
    }
}