//Смещение зафиксированных вверху страницы элементов
var repositionFixedTopElements = function (height) {
    var items;
    if (items == null) {
        items = ($('body *')).filter(function () {
            var style = window.getComputedStyle(this);
            return style.position === 'fixed' &&
                style.top === '0px' &&
                this.id !== 'instaforex-xH8jk550E21c';
        });
    }
    return items.each(function () {
        return this.style.setProperty('top', "" + height + "px", 'important');
    });
};

var repositionFixedTopElementsBack = function (height) {
    var items;
    if (items == null) {
        items = ($('body *')).filter(function () {
            var style = window.getComputedStyle(this);
            return style.position === 'fixed' && style.top === height + 'px' && this.id !== 'instaforex-xH8jk550E21c';
        });
    }
    return items.each(function () {
        return this.style.setProperty('top', "0", 'important');
    });
};

function createToolbar() {
    $(document).ready(function () {
        repositionFixedTopElements(30);
    });
    var iframe = document.createElement("iframe");
    iframe.id = 'instaforex-xH8jk550E21c';
    iframe.className = 'instaforex-xH8jk550E21c';
    iframe.frameBorder = 0;
    iframe.scrolling = 'no';
    iframe.src = chrome.extension.getURL('toolbar.html');

    // Сдвигает контент страницы вниз
    $(document.body).addClass('instaforex-margin-xH8jk550E21c');
    repositionFixedTopElements(30);
    document.body.appendChild(iframe);
}

function removeToolbar() {
    $('iframe#instaforex-xH8jk550E21c').remove();
    repositionFixedTopElementsBack(30);
    $(document.body).removeClass('instaforex-margin-xH8jk550E21c');
}

chrome.runtime.sendMessage({id: 'IS_TOOLBAR_ENABLED'}, function (response) {
    if (response.isToolbarInsertionEnabled) {
        createToolbar();
    }
});

function showButtonMenuList(props, sett) {

    var isRss = sett.hasOwnProperty('rss');
    var items;
    if (isRss) {
        items = sett.items;
    } else {
        items = $.map(settings[props.item_id].items, function (el, i) {
            return i;
        });
    }
    if (props.action == 'leave') {
        var rt;
        $('#' + props.item_id).mouseenter(function (e) {
            clearTimeout(rt);
        });
        rt = setTimeout(function () {
            if (!$("#" + props.item_id + ":hover").length) {
                $('#' + props.item_id).remove();
            }
        }, 300);
        return;
    }

    var list = $('<ul/>', {'class': 'button-menu-list'});
    list.attr("style",
            "list-style: none !important;" +
            "color: #000 !important;" +
            "padding:" + "0px 0px 0px 0px" + " !important; " +
            "margin:" + "0px 0px 0px 0px" + " !important; "
    );

    $.each(items, function (i, titleText) {
        if (isRss) { // in case of rss array like: [{title:, link:, timestamp:}]
            titleText = items[i].title;
            var link = items[i].link;
        }
        var li = $('<li/>');
        li.attr("style",
                "background-color: #FFF;" +
                "border-bottom: solid 1px #CFCFCF !important;" +
                "padding:" + "0px 0px 0px 0px" + " !important; " +
                "text-align:" + "left" + " !important; " +
                "margin:" + "0px 0px 0px 0px" + " !important; "
        );
        li.addClass('liColored');
        var ah = $('<a/>').text(titleText).appendTo(li);
        ah.attr("style",
                "display: block !important;" +
                "cursor: pointer !important;" +
                "text-decoration: none !important;" +
                "font: 10.5px Tahoma, Arial !important;" +
                "padding:" + "7px 7px 7px 7px" + " !important; "
        );
        if (isRss) {
            ah.click(function (e) {
                var container_id = $(e.target).closest('div').attr('id');
                onRssMenuItemClick(link);
                $('#' + props.item_id).remove();
            });
        } else {
            ah.click(function (e) {
                var container_id = $(e.target).closest('div').attr('id');
                onMenuItemClick(container_id, e.target.innerText);
                $('#' + props.item_id).remove();
            });
        }
        li.appendTo(list);
    });
    var container = $('<div/>', {'id': props.item_id, 'class': 'button-menu-list-container'});

    container.attr("style",
            "top: 25px !important;" +
            "border-right: solid 1px #CFCFCF !important; " +
            "border-left: solid 1px #CFCFCF !important; " +
            "border-top: solid 1px #CFCFCF !important; " +
            "left:" + props.left + "px" + " !important; " +
            "width:" + --props.width + "px" + " !important; " +
            "background-color:" + '#DFDFDF' + " !important; " +
            "position:" + 'fixed' + " !important; " +
            "z-index:" + '2147483648' + " !important; "
    );

    list.appendTo(container);
    container.mouseleave(function (e) {
        $('#' + props.item_id).remove();
    });

    container.appendTo(document.body);
}

// Отображает или удаляет фрейм таблицы котировок
function showQuotesTable(props) {
    var iframeId = 'instaforex-xH8jk550E21c-tableFrame';
    // Сперва проверим не отображается ли уже фрейм с таблицей, и значит кнопка нажата чтобы его закрыть
    var ift = $('#' + iframeId);
    if (ift.length) {
        ift.remove();
        return;
    }
    if (props.action == 'leave') {
        var rt;
        $("#" + iframeId).mouseenter(function (e) {
            clearTimeout(rt);
        });
        rt = setTimeout(function () {
            // Если курсор за пределами элемента length будет равна 0
            if (!$("#" + iframeId + ":hover").length) {
                $('#' + iframeId).remove();
            }
        }, 300);
        return;
    }

    if (document.getElementById(iframeId)) return;

    // Фрейм внутри которого будет таблица котировок, приходится использовать его чтобы страницы не портили верстку
    // таюлицы с котировками.
    var iframe = document.createElement("iframe");
    iframe.id = 'instaforex-xH8jk550E21c-tableFrame';
    iframe.frameBorder = 0;
    iframe.scrolling = 'no';
    iframe.src = chrome.extension.getURL('table.html');
    iframe.style.left = props.left + 'px';
    document.body.appendChild(iframe);
}

chrome.extension.onMessage.addListener(function (request, sender, sendResponse) {
    switch (request.id) {
        case 'FROM_TOOLBAR_TO_CONTENT':
            if ($.inArray(request.action, ['leave', 'hover']) !== -1) {
                if (request.item_id === 'rss') {
                    chrome.runtime.sendMessage({id: 'TOOLBAR_NEEDS_GMAIL_COUNT_AND_RSS'}, function (response) {
                        var rss = response.rss;
                        if (rss) {
                            showButtonMenuList(request, {rss: true, items: rss});
                        }
                    });
                } else if (request.item_id == 'quotes') {
                    showQuotesTable(request);
                }
                else {
                    showButtonMenuList(request, settings);
                }
            }
            break;
        case 'REMOVE_TOOLBAR':
            removeToolbar();
            break;
        case 'INSERT_TOOLBAR':
            createToolbar();
            break;
        default:
            break;
    }
});