﻿var isToolbarInsertionEnabled = true;

//http://partners.instaforex.com/ru/quotes_description.php/
var quotes = function () {
    var requestQuotes = function (onsucess) {
        $.ajax({
            url: 'https://quotes.instaforex.com/get_quotes.php?m=json',
            dataType: 'json',
            async: true,
            success: function (r) {
                console.log('on quotes resp');
                onsucess({id: 'ON_QUOTES_RECEIVED', quotes: r});
            }
        });
    };
    return {
        requestQuotes: requestQuotes
    }
}();

chrome.browserAction.onClicked.addListener(function () {
    isToolbarInsertionEnabled = !isToolbarInsertionEnabled;
    var command = isToolbarInsertionEnabled ? 'INSERT_TOOLBAR' : 'REMOVE_TOOLBAR';
    sendToAllTabs({id: command});
});

chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
    switch (request.id) {

        case "OPEN_THIS_URL":
            chrome.tabs.create({'url': request.url});
            break;
        case "FROM_TOOLBAR_TO_CONTENT":
            chrome.tabs.sendMessage(sender.tab.id, request);
            break;
        case "TOOLBAR_NEEDS_GMAIL_COUNT_AND_RSS":
            //console.log(JSON.parse(localStorage.rss));
            sendResponse({gmail: {gmailUnreadCount: localStorage.gmailUnreadCount}, rss: JSON.parse(localStorage.rss)});
            break;
        case "IS_TOOLBAR_ENABLED":
            sendResponse({isToolbarInsertionEnabled: isToolbarInsertionEnabled});
            break;
        case "QUOTES_TABLE_NEEDS_QUOTES":
            quotes.requestQuotes(function (data) {
                chrome.tabs.sendMessage(sender.tab.id, data)
            }.bind(this));
        default:
            break;
    }
});

function onInit() {
    console.log('Starting browser...');

    var rssReader = new RSSReader();
    rssReader.getNews();

    var gmailChecker = new GmailChecker();
    gmailChecker.startRequest();
    chrome.alarms.create('GmailCheckerAlarm', {
        delayInMinutes: 1,
        periodInMinutes: 1
    });
    chrome.alarms.onAlarm.addListener(function (alarm) {
        if (alarm && alarm.name == 'GmailCheckerAlarm') {
            rssReader.getNews();
            gmailChecker.startRequest();
        }
    });
}

onInit();